# returns the index of a column in the wife lists
proc play:index_of {table_name column_name} {
	set i [lindex [lsearch -inline -index 1 $::PLAY_TABLES($table_name) "$column_name"] 0]
	if {$i == ""} {
		error "Can't find index of $column_name in $table_name"
	} else {
		return $i
	}
}

# status can be "active", "closed" or "archived"
# returns the full path
proc project:folder:get_location_path {status} {
	set location_value [lindex [lsearch -inline -index 0 $::PROJECT_FOLDER_LOCATIONS $status] 1]
	return [project:folder:get_location_path2 $location_value]
}

proc project:folder:get_location_path2 {location_value} {
	if {[lindex $location_value 0] == 0} {
		# relative to FILES_HOME
		return [file join $::FILES_HOME [lindex $location_value 1]]
	} else {
		# absolute path
		return [lindex $location_value 1]
	}
}

proc play:scan_for_shares {} {
	#log "Play: Scanning for shares..." 1
	
	lassign [wife::send get_var PLAY_PROXIES_LOCATION_TYPE] ok ::PLAY_PROXIES_LOCATION_TYPE error_string
	if {!$ok} {
		log "ERROR (Play Auto Sharing): $error_string"
		return
	}
	
	lassign [wife::send play:xmlrpc:cloud_reachable] ok cloud_reachable error_string
	if {!$ok} {
		log "ERROR (Play Auto Sharing): $error_string"
		return
	}
	if {!$cloud_reachable} {
		return
	}
	
	set cache_id [generic:click]
	lassign [wife::send play:server:clear_existing_share_titles_cache $cache_id] ok result error_string
	if {!$ok} {
		log "ERROR (Play Auto Sharing): $error_string"
		return
	}
	
	foreach projects_root [lsort -unique [list [project:folder:get_location_path "active"] [project:folder:get_location_path "closed"]]] {
		foreach project_dir [glob -dir "$projects_root" -nocomplain -type d *] {
			if {$::CREATE_SHARES_DIR} {
				if {![file exists [file join $project_dir "$::CHECK_FOLDER_NAMED"]]} {
					file mkdir [file join $project_dir "$::CHECK_FOLDER_NAMED"]
				}
			}
			foreach shares_root_dir [glob -dir $project_dir -nocomplain -type d "$::CHECK_FOLDER_NAMED"] {
				set mtime [file mtime $shares_root_dir]
				# only process folders with an mtime that is less than 1 week minutes but more than 30 seconds:
				if {$mtime < $::check_folders_newer_than_this || $mtime > $::check_folders_older_than_this} {
					#log "Skipping $::CHECK_FOLDER_NAMED dir with mtime [clock format $mtime -format {%Y-%m-%d %H:%M:%S}]: $shares_root_dir"
				} else {
					#log "Checking $::CHECK_FOLDER_NAMED dir with mtime [clock format $mtime -format {%Y-%m-%d %H:%M:%S}]: $shares_root_dir"

					# check if there are any sub directories. if not, there is no point continuing:
					if {[llength [glob -dir "$shares_root_dir" -nocomplain -type d *]] == 0 && [llength [glob -dir "$shares_root_dir" -nocomplain -type f *]] == 0} {
						continue
					}

					lassign [wife::send project:get_project_with_folder_path $project_dir] ok project error_string
					if {!$ok} {
						log "ERROR (Play Auto Sharing): $error_string"
						continue
					}
					if {$project == ""} {
						log "WARNING: This folder doesn't belong to any known project: $project_dir"
						continue
					}
					set prj_id [lindex $project 0]

					set share_locations [list]
					foreach share_dir [glob -dir "$shares_root_dir" -nocomplain -type d *] {
						lappend share_locations [list d $share_dir]
					}
					# if the proxies are created in the same dir (or sub dir) then it will cause the proxies to be shared as well. that would not be good, so require "SEPARATE" location:
					if {$::PLAY_PROXIES_LOCATION_TYPE == "SEPARATE"} {
						foreach share_single_file [glob -dir "$shares_root_dir" -nocomplain -type f *] {
							lappend share_locations [list f $share_single_file]
						}
					}

					lassign [wife::send play:server:get_existing_share_titles_for_project $prj_id $cache_id] ok existing_share_titles error_string
					if {!$ok} {
						log "ERROR (Play Auto Sharing): $error_string"
						return
					}

					foreach share_location $share_locations {
						lassign $share_location share_location_type folder_or_file_path
						
						# is there already a share with the same title as this folder?
						set found_share 0
						if {[file tail $folder_or_file_path] in $existing_share_titles} {
							set found_share 1
						}
						if {!$found_share} {
							log "Sharing $folder_or_file_path"

							# figure out the share creator:
							set project_owner_id [lindex $project 2 0]
							if {$project_owner_id != ""} {
								lassign [wife::send object:get_list "user" $project_owner_id] ok project_owner error_string
								if {!$ok} {
									log "ERROR (Play Auto Sharing): $error_string"
									continue
								}
								set share_creator_email [lindex $project_owner 4]
								set share_creator_name "[lindex $project_owner 2] [lindex $project_owner 1]"
							}

							lassign [wife::send play:server:auto_create_share_for_project $prj_id $share_location_type $folder_or_file_path $share_creator_email $share_creator_name] ok shared_files error_string
							if {!$ok} {
								log "ERROR (Play Auto Sharing): $error_string"
								continue
							}

							foreach shared_file $shared_files {
								log "   - [file tail $shared_file]"
							}
						}
					}

				}
			}
		}
	}
	#log "Play: DONE Scanning for shares." 1
}

proc play:scan_all_synced {} {
	#log "Play: Scanning synced folders..." 1

	lassign [wife::send get_var PLAY_PROXIES_LOCATION_TYPE] ok ::PLAY_PROXIES_LOCATION_TYPE error_string
	if {!$ok} {
		log "ERROR (Play Synced Folder Scan): $error_string"
		return
	}
	
	if {$::PLAY_PROXIES_LOCATION_TYPE == "SAME_DIR"} {
		# if the proxies are created in the same folder, the auto sharing function might see them as new files and will transcode them too, resulting in infinite transcoding of stuff...
		log "Synced folders is not supported when using Proxies Location \"Same Folder\""
		return
	}
	
	lassign [wife::send play:xmlrpc:cloud_reachable] ok cloud_reachable error_string
	if {!$ok} {
		log "ERROR (Play Synced Folder Scan): $error_string"
		return
	}
	if {!$cloud_reachable} {
		return
	}

	lassign [wife::send play:server:get_all_synced_folder_info] ok result error_string
	if {!$ok} {
		log "ERROR (Play Synced Folder Scan): $error_string"
		return
	}
	if {![lindex $result 0]} {
		log "Aborting synced folder scan because: [lindex $result 1]"
		return
	}
	set synced_folders_elems [lindex $result 1]
	
	#log "synced_folders_elems: $synced_folders_elems"
	
	foreach synced_folders_elem $synced_folders_elems {
		lassign $synced_folders_elem prj_id project_cloud_id share_ids synced_folder_paths_play_server_pov
		
		foreach share_id $share_ids synced_folder_path_play_server_pov $synced_folder_paths_play_server_pov {
			lassign [wife::send play:paths:play_server_path_to_fw_server_path $synced_folder_path_play_server_pov] ok synced_with_folder_fw_pov error_string
			if {!$ok} {
				log "ERROR (Play Synced Folder Scan): $error_string"
				continue
			}
			if {$synced_with_folder_fw_pov == ""} {
				log "ERROR (Play Synced Folder Scan): Could not map Play Server Path to farmerswife Server Path, due to incorrect Network Storage Paths. Play Server Path: $synced_folder_path_play_server_pov"
				continue
			}
			set share_dir $synced_with_folder_fw_pov
			
			#log "Checking synced folder: $synced_with_folder_fw_pov ($synced_folder_path_play_server_pov)"
			
			if {![file exists $synced_with_folder_fw_pov]} {
				# the folder has been deleted => delete the share:
				log "Synced folder was deleted => deleting share with id $share_id"
				lassign [wife::send play:server:delete_shares [list $share_id]] ok result error_string
				if {!$ok} {
					log "ERROR (Play Synced Folder Scan): $error_string"
					return
				}
				if {$result == 0} {
					log "ERROR (Play Synced Folder Scan): Failed deleting share."
				}
				continue
			}
			
			set mtime [file mtime $synced_with_folder_fw_pov]
			if {$mtime < $::check_folders_newer_than_this || $mtime > $::check_folders_older_than_this} {
				#log "Skipping synced dir with mtime [clock format $mtime -format {%Y-%m-%d %H:%M:%S}]: $share_dir"
			} else {
				#log "Checking synced dir with mtime [clock format $mtime -format {%Y-%m-%d %H:%M:%S}]: $share_dir"

				lassign [wife::send play:server:check_synced_folder $share_id] ok tmp error_string
				if {!$ok} {
					log "ERROR (Play Synced Folder Scan): $error_string"
					continue
				}
				lassign $tmp ok error_msg
				if {!$ok} {
					log "ERROR (Play Synced Folder Scan): Failed checking synced folder: $error_msg"
					continue
				}
				
			}
		}
	}
	
	#log "Play: DONE Scanning synced folders." 1
	return
}
